%------------------------------------------------------------------------------
% File     : SEU552^2 : TPTP v7.4.0. Bugfixed v4.0.0.
% Domain   : Set Theory
% Problem  : A simple congruence property of setadjoin
% Version  : Especial > Reduced > Especial.
% English  : (forall x:i.forall y:i.x = y -> (forall z:i.forall u:i.z = u ->
%            setadjoin x z = setadjoin y u))

% Refs     : [Bro08] Brown (2008), Email to G. Sutcliffe
% Source   : [Bro08]
% Names    : ZFC054l [Bro08]

% Status   : Theorem
% Rating   : 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v4.1.0, 0.00 v4.0.0
% Syntax   : Number of formulae    :    2 (   0 unit;   1 type;   0 defn)
%            Number of atoms       :   13 (   3 equality;   8 variable)
%            Maximal formula depth :   10 (   7 average)
%            Number of connectives :    6 (   0   ~;   0   |;   0   &;   4   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    2 (   2   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    2 (   1   :;   0   =)
%            Number of variables   :    4 (   0 sgn;   4   !;   0   ?;   0   ^)
%                                         (   4   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : http://mathgate.info/detsetitem.php?id=29
%          : 
%          : v4.0.0 - Added setadjoin type
%------------------------------------------------------------------------------
thf(setadjoin,type,(
    setadjoin: $i > $i > $i )).

thf(setadjoin__Cong,conjecture,(
    ! [Xx: $i,Xy: $i] :
      ( ( Xx = Xy )
     => ! [Xz: $i,Xu: $i] :
          ( ( Xz = Xu )
         => ( ( setadjoin @ Xx @ Xz )
            = ( setadjoin @ Xy @ Xu ) ) ) ) )).

%------------------------------------------------------------------------------
